/**
 * \file: exchnd_names.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * String representations of the exception handler enums defined in the kernel
 * header.
 *
 * \component: exchndd
 *
 * \author: Kai Tomerius (ktomerius@de.adit-jv.com)
 *
 * \copyright (c) 2013 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef __EXCHND_NAMES_H__
#define __EXCHND_NAMES_H__

#define ARRAY_SIZE(arr) (sizeof(arr) / sizeof((arr)[0]))

/* Helper functions to convert strings to numbers and vice versa */
extern const char *conf_name(enum exchnd_conf conf);
extern const char *signal_conf_name(enum exchnd_signal_conf conf);
extern const char *trigger_name(enum exchnd_triggers trigger);
extern const char *module_name(enum exchnd_modules module);
extern const char *signal_name(int sig);
extern enum exchnd_triggers get_trigger(const char *trigger_name);
extern enum exchnd_modules get_module(const char *module_name);
extern int get_signal(const char *signal_name);
extern enum exchnd_conf get_conf(const char *conf_name);
extern enum exchnd_signal_conf get_sig_conf(const char *conf_name);

#endif /* ifndef __EXCHND_NAMES_H__ */